XMLRPC for PHP
==============

Requirements
------------

The following requirements should be met prior to using 'XMLRPC for PHP':

* PHP 5.3.0 or later

* the php "curl" extension is needed if you wish to use HTTPS, HTTP2, HTTP 1.1 or NTLM Auth to communicate with remote
  servers

* the php "mbstring" extension is not required, but when installed it allows reception of requests/responses in character
  sets other than ASCII,LATIN-1,UTF-8.

* the php "zlib" extension is not required, but when installed it allows sending compressed requests and receiving
  compressed responses even without the "curl" extension

* the php "xmlrpc" native extension is not required, but if it is installed, there will be no interference with the
  operation of this library.

Installation instructions
-------------------------

Installation of the library is quite easy:

1.  Via Composer (highly recommended)

    1.  Install composer if you don't have it already present on your system.
        Depending on how you install, you may end up with a composer.phar file in your directory.
        In that case, no worries! Just substitute 'php composer.phar' for 'composer' in the commands below.

    2.  If you're creating a new project, create a new empty directory for it.

    3.  Open a terminal and use Composer to grab the library.

            $ composer require phpxmlrpc/phpxmlrpc:^4.9

    4.  Write your code.
        Once Composer has downloaded the component(s), all you need to do is include the vendor/autoload.php file that
        was generated by Composer. This file takes care of autoloading all the libraries so that you can use them
        immediately, including phpxmlrpc:

            // File example: src/script.php

            // update this to the path to the "vendor/" directory, relative to this file
            require_once __DIR__.'/../vendor/autoload.php';

            use PhpXmlRpc\Value;
            use PhpXmlRpc\Request;
            use PhpXmlRpc\Client;

            $client = new Client('https://some/server');
            $response = $client->send(new Request('method', array(new Value('parameter'))));

    5.  IMPORTANT! Make sure that the vendor/phpxmlrpc directory is not directly accessible from the internet,
        as leaving it open to access means that any visitor can trigger execution of php code such as
        the built-in debugger.

2.  Via manual download and autoload configuration

    1.  download the zip or tarball version of the phpxmlrpc library from GitHub and unzip it in a temporary folder

    2.  copy the contents of the extracted src/ folder to any location required by your
        application (it can be inside the web server root or not).

    3.  configure your app's autoloading mechanism so that all classes in the PhpXmlRpc namespace are loaded
        from that location: any PSR-4 compliant autoloader can do that, if you don't have any there is one
        available in src/Autoloader.php

    4.  Write your code.

            // File example: script.php

            require_once __DIR__.'my_autoloader.php';

            use PhpXmlRpc\Value;
            use PhpXmlRpc\Request;
            use PhpXmlRpc\Client;

            $client = new Client('https://some/server');
            $response = $client->send(new Request('method', array(new Value('parameter'))));

    5.  IMPORTANT! Make sure that the phpxmlrpc root directory is not directly accessible from the internet,
        as leaving it open to access means that any visitor can trigger execution of php code such as
        the built-in debugger.

Tips
----

* To reduce the size of the download, the demo files are not part of the default package installed with Composer.
  You can either check them out online at https://github.com/gggeek/phpxmlrpc/tree/master/demo, or make sure they are
  available locally, by either installing the library using Composer option `--prefer-install=source`, running
  `./taskfile download_demos` (requires bash, curl, tar commands), or manually downloading them from
  https://github.com/gggeek/phpxmlrpc/releases.

* The xml-rpc debugger included with the library can be augmented by installing an extra package for js-based interaction.
  See the [user manual](doc/manual/phpxmlrpc_manual.adoc) for details on installing it.

* When installing the phpxmlrpc library via Composer, Composer takes care of verifying that all the prerequisites are met.
  In case you are installing the library via manual download, or if you suspect that your php installation might be missing
  some feature required by the library, you can check the compatibility of phpxmlrpc with your php installation by
  executing the php file `verify_compat.php`. That file is not part of the default package and has to be downloaded
  separately, eg:

      curl -fsSL -o verify_compat.php https://raw.githubusercontent.com/gggeek/phpxmlrpc/master/extras/verify_compat.php && php verify_compat.php
