<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\MenuItem;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $ads = [
            ['id' => 1, 'parent_key' => NULL, 'order' => 1, 'key' => 'ai_panel', 'route' => NULL, 'route_slug' => NULL, 'label' => 'AI Panel', 'icon' => NULL, 'type' => 'label', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 0],
            ['id' => 2, 'parent_key' => NULL, 'order' => 2, 'key' => 'user_dashboard', 'route' => 'user.dashboard', 'route_slug' => NULL, 'label' => 'Dashboard', 'icon' => 'fa-solid fa-chart-tree-map', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 3, 'parent_key' => NULL, 'order' => 3, 'key' => 'ai_writer', 'route' => 'user.templates', 'route_slug' => NULL, 'label' => 'AI Writer', 'icon' => 'fa-solid fa-microchip-ai', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 4, 'parent_key' => NULL, 'order' => 4, 'key' => 'ai_article_wizard', 'route' => 'user.wizard', 'route_slug' => NULL, 'label' => 'AI Article Wizard', 'icon' => 'fa-solid fa-sparkles', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 5, 'parent_key' => NULL, 'order' => 5, 'key' => 'smart_editor', 'route' => 'user.smart.editor', 'route_slug' => NULL, 'label' => 'Smart Editor', 'icon' => 'fa-solid fa-feather', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 6, 'parent_key' => NULL, 'order' => 6, 'key' => 'ai_images', 'route' => 'user.images', 'route_slug' => NULL, 'label' => 'AI Images', 'icon' => 'fa-solid fa-camera-viewfinder', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 7, 'parent_key' => NULL, 'order' => 7, 'key' => 'ai_rewriter', 'route' => 'user.rewriter', 'route_slug' => NULL, 'label' => 'AI ReWriter', 'icon' => 'fa-solid fa-pen-line', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 8, 'parent_key' => NULL, 'order' => 8, 'key' => 'ai_voiceover', 'route' => 'user.voiceover', 'route_slug' => NULL, 'label' => 'AI Voiceover', 'icon' => 'fa-solid fa-waveform-lines', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 9, 'parent_key' => NULL, 'order' => 9, 'key' => 'voice_cloning', 'route' => 'user.voiceover.clone', 'route_slug' => NULL, 'label' => 'Voice Cloning', 'icon' => 'fa-solid fa-user-music', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 10, 'parent_key' => NULL, 'order' => 10, 'key' => 'sound_studio', 'route' => 'user.studio', 'route_slug' => NULL, 'label' => 'Sound Studio', 'icon' => 'fa-solid fa-photo-film-music', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 11, 'parent_key' => NULL, 'order' => 11, 'key' => 'ai_speech_to_text', 'route' => 'user.transcribe', 'route_slug' => NULL, 'label' => 'AI Speech to Text', 'icon' => 'fa-solid fa-folder-music', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 12, 'parent_key' => NULL, 'order' => 12, 'key' => 'ai_chat', 'route' => 'user.chat', 'route_slug' => NULL, 'label' => 'AI Chat', 'icon' => 'fa-solid fa-message-captions', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 13, 'parent_key' => NULL, 'order' => 13, 'key' => 'ai_realtime_chat', 'route' => 'user.chat.realtime', 'route_slug' => NULL, 'label' => 'AI Realtime Voice Chat', 'icon' => 'fa-solid fa-waveform-lines', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 14, 'parent_key' => NULL, 'order' => 14, 'key' => 'ai_vision', 'route' => 'user.vision', 'route_slug' => NULL, 'label' => 'AI Vision', 'icon' => 'fa-solid fa-brain-circuit', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 15, 'parent_key' => NULL, 'order' => 15, 'key' => 'ai_file_chat', 'route' => 'user.chat.file', 'route_slug' => NULL, 'label' => 'AI File Chat', 'icon' => 'fa-solid fa-folder-grid', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 16, 'parent_key' => NULL, 'order' => 16, 'key' => 'ai_web_chat', 'route' => 'user.chat.web', 'route_slug' => NULL, 'label' => 'AI Web Chat', 'icon' => 'fa-solid fa-globe', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 17, 'parent_key' => NULL, 'order' => 17, 'key' => 'ai_youtube', 'route' => 'user.youtube', 'route_slug' => NULL, 'label' => 'AI Youtube', 'icon' => 'fa-brands fa-youtube', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 18, 'parent_key' => NULL, 'order' => 18, 'key' => 'ai_rss', 'route' => 'user.rss', 'route_slug' => NULL, 'label' => 'AI RSS', 'icon' => 'fa-solid fa-rss', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 19, 'parent_key' => NULL, 'order' => 19, 'key' => 'ai_chat_image', 'route' => 'user.chat.image', 'route_slug' => NULL, 'label' => 'AI Chat Image', 'icon' => 'fa-solid fa-image-landscape', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 20, 'parent_key' => NULL, 'order' => 20, 'key' => 'ai_code', 'route' => 'user.codex', 'route_slug' => NULL, 'label' => 'AI Code', 'icon' => 'fa-solid fa-square-code', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 21, 'parent_key' => NULL, 'order' => 21, 'key' => 'brand_voice', 'route' => 'user.brand', 'route_slug' => NULL, 'label' => 'Brand Voice', 'icon' => 'fa-solid fa-signature', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 22, 'parent_key' => NULL, 'order' => 22, 'key' => 'ai_video_image', 'route' => 'user.video', 'route_slug' => NULL, 'label' => 'AI Video Image', 'icon' => 'fa-solid fa-video', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 23, 'parent_key' => NULL, 'order' => 23, 'key' => 'ai_video_text', 'route' => 'user.video.text', 'route_slug' => NULL, 'label' => 'AI Video Text', 'icon' => 'fa-solid fa-video-plus', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 24, 'parent_key' => NULL, 'order' => 24, 'key' => 'ai_video_video', 'route' => 'user.video.video', 'route_slug' => NULL, 'label' => 'AI Video Video', 'icon' => 'fa-solid fa-camera-movie', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 25, 'parent_key' => NULL, 'order' => 25, 'key' => 'ai_photo_studio', 'route' => 'user.photo.studio', 'route_slug' => NULL, 'label' => 'AI Photo Studio', 'icon' => 'fa-solid fa-photo-film', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 26, 'parent_key' => NULL, 'order' => 26, 'key' => 'ai_product_photo', 'route' => 'user.extension.product.photo', 'route_slug' => NULL, 'label' => 'AI Product Photo', 'icon' => 'fa-solid fa-aperture', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 27, 'parent_key' => NULL, 'order' => 27, 'key' => 'faceswap', 'route' => 'user.extension.faceswap', 'route_slug' => NULL, 'label' => 'Faceswap', 'icon' => 'fa-solid fa-masks-theater', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 28, 'parent_key' => NULL, 'order' => 28, 'key' => 'ai_social_media', 'route' => 'user.extension.social.media', 'route_slug' => NULL, 'label' => 'AI Social Media', 'icon' => 'fa-solid fa-share-nodes', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 29, 'parent_key' => NULL, 'order' => 29, 'key' => 'ai_music', 'route' => 'user.extension.music', 'route_slug' => NULL, 'label' => 'AI Music', 'icon' => 'fa-solid fa-list-music', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 30, 'parent_key' => NULL, 'order' => 30, 'key' => 'ai_textract', 'route' => 'user.extension.textract', 'route_slug' => NULL, 'label' => 'AI Textract', 'icon' => 'fa-solid fa-scanner-touchscreen', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 31, 'parent_key' => NULL, 'order' => 31, 'key' => 'integration', 'route' => 'user.integration', 'route_slug' => NULL, 'label' => 'Integrations', 'icon' => 'fa-solid fa-rectangles-mixed', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 32, 'parent_key' => NULL, 'order' => 32, 'key' => 'ai_plagiarism_checker', 'route' => 'user.plagiarism', 'route_slug' => NULL, 'label' => 'AI Plagiarism Checker', 'icon' => 'fa-solid fa-shield-check', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 33, 'parent_key' => NULL, 'order' => 33, 'key' => 'ai_avatar', 'route' => 'user.extension.avatar', 'route_slug' => NULL, 'label' => 'AI Avatar', 'icon' => 'fa-solid fa-aperture', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 34, 'parent_key' => NULL, 'order' => 34, 'key' => 'ai_content_detector', 'route' => 'user.detector', 'route_slug' => NULL, 'label' => 'AI Content Detector', 'icon' => 'fa-solid fa-user-secret', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 35, 'parent_key' => NULL, 'order' => 35, 'key' => 'voice_isolator', 'route' => 'user.voice.isolator', 'route_slug' => NULL, 'label' => 'Voice Isolator', 'icon' => 'fa-solid fa-record-vinyl', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 36, 'parent_key' => NULL, 'order' => 36, 'key' => 'documents', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Documents', 'icon' => 'fa-solid fa-folder-bookmark', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 37, 'parent_key' => 36, 'order' => 37, 'key' => 'all_documents', 'route' => 'user.documents', 'route_slug' => NULL, 'label' => 'All Documents', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 38, 'parent_key' => 36, 'order' => 38, 'key' => 'all_images', 'route' => 'user.documents.images', 'route_slug' => NULL, 'label' => 'All Images', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 39, 'parent_key' => 36, 'order' => 39, 'key' => 'all_voiceovers', 'route' => 'user.documents.voiceovers', 'route_slug' => NULL, 'label' => 'All Voiceovers', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 40, 'parent_key' => 36, 'order' => 40, 'key' => 'all_transcripts', 'route' => 'user.documents.transcripts', 'route_slug' => NULL, 'label' => 'All Transcripts', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 41, 'parent_key' => 36, 'order' => 41, 'key' => 'all_codes', 'route' => 'user.documents.codes', 'route_slug' => NULL, 'label' => 'All Codes', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 42, 'parent_key' => 36, 'order' => 42, 'key' => 'workbooks', 'route' => 'user.workbooks', 'route_slug' => NULL, 'label' => 'Workbooks', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 500, 'parent_key' => NULL, 'order' => 500, 'key' => 'divider_1', 'route' => NULL, 'route_slug' => NULL, 'label' => NULL, 'icon' => 'fa-solid fa-angles-right', 'type' => 'divider', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 0],
            ['id' => 501, 'parent_key' => NULL, 'order' => 501, 'key' => 'account', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Account', 'icon' => NULL, 'type' => 'label', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 0],
            ['id' => 502, 'parent_key' => NULL, 'order' => 502, 'key' => 'subscription_plans', 'route' => 'user.plans', 'route_slug' => NULL, 'label' => 'Subscription Plans', 'icon' => 'fa-solid fa-box-circle-check', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 503, 'parent_key' => NULL, 'order' => 503, 'key' => 'team_members', 'route' => 'user.team', 'route_slug' => NULL, 'label' => 'Team Members', 'icon' => 'fa-solid fa-people-arrows', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 504, 'parent_key' => NULL, 'order' => 504, 'key' => 'my_account', 'route' => 'user.profile', 'route_slug' => NULL, 'label' => 'My Account', 'icon' => 'fa-solid fa-id-badge', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 505, 'parent_key' => NULL, 'order' => 505, 'key' => 'affiliate_program', 'route' => 'user.referral', 'route_slug' => NULL, 'label' => 'Affiliate Program', 'icon' => 'fa-solid fa-badge-dollar', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 49, 'parent_key' => NULL, 'order' => 49, 'key' => 'divider_2', 'route' => NULL, 'route_slug' => NULL, 'label' => NULL, 'icon' => 'fa-solid fa-angles-right', 'type' => 'divider', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 0],
            ['id' => 50, 'parent_key' => NULL, 'order' => 50, 'key' => 'admin_panel', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Admin Panel', 'icon' => NULL, 'type' => 'label', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 0],
            ['id' => 51, 'parent_key' => NULL, 'order' => 51, 'key' => 'admin_dashboard', 'route' => 'admin.dashboard', 'route_slug' => NULL, 'label' => 'Dashboard', 'icon' => 'fa-solid fa-chart-tree-map', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 52, 'parent_key' => NULL, 'order' => 52, 'key' => 'marketplace', 'route' => 'admin.extensions', 'route_slug' => NULL, 'label' => 'Marketplace', 'icon' => 'fa-solid fa-objects-column', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 53, 'parent_key' => NULL, 'order' => 53, 'key' => 'themes', 'route' => 'admin.themes', 'route_slug' => NULL, 'label' => 'Themes', 'icon' => 'fa-solid fa-palette', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 54, 'parent_key' => NULL, 'order' => 54, 'key' => 'ai_management', 'route' => NULL, 'route_slug' => NULL, 'label' => 'AI Management', 'icon' => 'fa-solid fa-microchip-ai', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 55, 'parent_key' => 54, 'order' => 55, 'key' => 'ai_usage_dashboard', 'route' => 'admin.davinci.dashboard', 'route_slug' => NULL, 'label' => 'AI Usage Dashboard', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 56, 'parent_key' => 54, 'order' => 56, 'key' => 'ai_image_prompt', 'route' => 'admin.davinci.image.prompt', 'route_slug' => NULL, 'label' => 'AI Image Prompts', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 57, 'parent_key' => 54, 'order' => 57, 'key' => 'ai_voiceover_voices', 'route' => 'admin.davinci.voices', 'route_slug' => NULL, 'label' => 'AI Voiceover Voices', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 58, 'parent_key' => 54, 'order' => 58, 'key' => 'ai_settings', 'route' => 'admin.davinci.configs', 'route_slug' => NULL, 'label' => 'AI Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 59, 'parent_key' => NULL, 'order' => 59, 'key' => 'template_settings', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Template Settings', 'icon' => 'fa-solid fa-feather', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 60, 'parent_key' => 59, 'order' => 60, 'key' => 'template_categories', 'route' => 'admin.davinci.custom.category', 'route_slug' => NULL, 'label' => 'Template Categories', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 61, 'parent_key' => 59, 'order' => 61, 'key' => 'original_templates', 'route' => 'admin.davinci.templates', 'route_slug' => NULL, 'label' => 'Original Templates', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 62, 'parent_key' => 59, 'order' => 62, 'key' => 'custom_templates', 'route' => 'admin.davinci.custom', 'route_slug' => NULL, 'label' => 'Custom Templates', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 63, 'parent_key' => NULL, 'order' => 63, 'key' => 'chat_settings', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Chat Settings', 'icon' => 'fa-solid fa-brain-circuit', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 64, 'parent_key' => 63, 'order' => 64, 'key' => 'chat_categories', 'route' => 'admin.davinci.chat.category', 'route_slug' => NULL, 'label' => 'Chat Categories', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 65, 'parent_key' => 63, 'order' => 65, 'key' => 'chat_prompts', 'route' => 'admin.davinci.chat.prompt', 'route_slug' => NULL, 'label' => 'Chat Prompts', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 66, 'parent_key' => 63, 'order' => 66, 'key' => 'original_chatbots', 'route' => 'admin.davinci.chats', 'route_slug' => NULL, 'label' => 'Original Chatbots', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 67, 'parent_key' => 63, 'order' => 67, 'key' => 'chat_assistants', 'route' => 'admin.chat.assistant', 'route_slug' => NULL, 'label' => 'Chat Assistants', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 68, 'parent_key' => NULL, 'order' => 68, 'key' => 'user_management', 'route' => NULL, 'route_slug' => NULL, 'label' => 'User Management', 'icon' => 'fa-solid fa-id-badge', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 69, 'parent_key' => 68, 'order' => 69, 'key' => 'user_dashboard_admin', 'route' => 'admin.user.dashboard', 'route_slug' => NULL, 'label' => 'User Dashboard', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 70, 'parent_key' => 68, 'order' => 70, 'key' => 'user_list', 'route' => 'admin.user.list', 'route_slug' => NULL, 'label' => 'User List', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 71, 'parent_key' => 68, 'order' => 71, 'key' => 'activity_monitoring', 'route' => 'admin.user.activity', 'route_slug' => NULL, 'label' => 'Activity Monitoring', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 72, 'parent_key' => NULL, 'order' => 72, 'key' => 'finance_management', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Finance Management', 'icon' => 'fa-solid fa-sack-dollar', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 73, 'parent_key' => 72, 'order' => 73, 'key' => 'finance_dashboard', 'route' => 'admin.finance.dashboard', 'route_slug' => NULL, 'label' => 'Finance Dashboard', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 74, 'parent_key' => 72, 'order' => 74, 'key' => 'transactions', 'route' => 'admin.finance.transactions', 'route_slug' => NULL, 'label' => 'Transactions', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 75, 'parent_key' => 72, 'order' => 75, 'key' => 'subscription_plans_admin', 'route' => 'admin.finance.plans', 'route_slug' => NULL, 'label' => 'Subscription Plans', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 76, 'parent_key' => 72, 'order' => 76, 'key' => 'prepaid_plans', 'route' => 'admin.finance.prepaid', 'route_slug' => NULL, 'label' => 'Prepaid Plans', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 77, 'parent_key' => 72, 'order' => 77, 'key' => 'subscribers', 'route' => 'admin.finance.subscriptions', 'route_slug' => NULL, 'label' => 'Subscribers', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 78, 'parent_key' => 72, 'order' => 78, 'key' => 'promocodes', 'route' => 'admin.finance.promocodes', 'route_slug' => NULL, 'label' => 'Promocodes', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            
            ['id' => 79, 'parent_key' => 72, 'order' => 79, 'key' => 'gift_cards', 'route' => 'admin.finance.gifts', 'route_slug' => NULL, 'label' => 'Gift Cards', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 80, 'parent_key' => 72, 'order' => 80, 'key' => 'referral_system', 'route' => 'admin.referral.settings', 'route_slug' => NULL, 'label' => 'Referral System', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 81, 'parent_key' => 72, 'order' => 81, 'key' => 'referral_payouts', 'route' => 'admin.referral.payouts', 'route_slug' => NULL, 'label' => 'Referral Payouts', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 82, 'parent_key' => 72, 'order' => 82, 'key' => 'invoice_settings', 'route' => 'admin.settings.invoice', 'route_slug' => NULL, 'label' => 'Invoice Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 83, 'parent_key' => 72, 'order' => 83, 'key' => 'payment_settings', 'route' => 'admin.finance.settings', 'route_slug' => NULL, 'label' => 'Finance Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 84, 'parent_key' => NULL, 'order' => 84, 'key' => 'support_requests', 'route' => 'admin.support', 'route_slug' => NULL, 'label' => 'Support Requests', 'icon' => 'fa-solid fa-message-question', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 85, 'parent_key' => NULL, 'order' => 85, 'key' => 'email_notifications', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Email & Notifications', 'icon' => 'fa-solid fa-envelope-circle-check', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 86, 'parent_key' => 85, 'order' => 86, 'key' => 'newsletter', 'route' => 'admin.email.newsletter', 'route_slug' => NULL, 'label' => 'Newsletter', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 87, 'parent_key' => 85, 'order' => 87, 'key' => 'email_templates', 'route' => 'admin.email.templates', 'route_slug' => NULL, 'label' => 'Email Templates', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 88, 'parent_key' => 85, 'order' => 88, 'key' => 'mass_notifications', 'route' => 'admin.notifications', 'route_slug' => NULL, 'label' => 'Mass Notifications', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 89, 'parent_key' => 85, 'order' => 89, 'key' => 'system_notifications', 'route' => 'admin.notifications.system', 'route_slug' => NULL, 'label' => 'System Notifications', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 90, 'parent_key' => NULL, 'order' => 90, 'key' => 'frontend_management', 'route' => NULL, 'route_slug' => NULL, 'label' => 'Frontend Management', 'icon' => 'fa-solid fa-earth-americas', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 91, 'parent_key' => 90, 'order' => 91, 'key' => 'frontend_settings', 'route' => 'admin.settings.frontend', 'route_slug' => NULL, 'label' => 'Frontend Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 92, 'parent_key' => 90, 'order' => 92, 'key' => 'frontend_sections', 'route' => 'admin.settings.section', 'route_slug' => NULL, 'label' => 'Frontend Sections', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 93, 'parent_key' => 90, 'order' => 93, 'key' => 'seo_management', 'route' => 'admin.settings.seo', 'route_slug' => NULL, 'label' => 'SEO Manager', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 94, 'parent_key' => 90, 'order' => 94, 'key' => 'pages', 'route' => 'admin.settings.page', 'route_slug' => NULL, 'label' => 'Pages', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 95, 'parent_key' => 90, 'order' => 95, 'key' => 'logos', 'route' => 'admin.settings.appearance', 'route_slug' => NULL, 'label' => 'Logos', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 96, 'parent_key' => 90, 'order' => 96, 'key' => 'how_it_works_section', 'route' => 'admin.settings.step', 'route_slug' => NULL, 'label' => 'How it Works Section', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 97, 'parent_key' => 90, 'order' => 97, 'key' => 'use_cases_section', 'route' => 'admin.settings.case', 'route_slug' => NULL, 'label' => 'Use Cases Section', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 98, 'parent_key' => 90, 'order' => 98, 'key' => 'ai_tools_section', 'route' => 'admin.settings.tool', 'route_slug' => NULL, 'label' => 'AI Tools Section', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 99, 'parent_key' => 90, 'order' => 99, 'key' => 'features_section', 'route' => 'admin.settings.feature', 'route_slug' => NULL, 'label' => 'Features Section', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 100, 'parent_key' => 90, 'order' => 100, 'key' => 'clients_section', 'route' => 'admin.settings.client', 'route_slug' => NULL, 'label' => 'Clients Section', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 101, 'parent_key' => 90, 'order' => 101, 'key' => 'reviews_manager', 'route' => 'admin.settings.review', 'route_slug' => NULL, 'label' => 'Reviews Manager', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 102, 'parent_key' => 90, 'order' => 102, 'key' => 'blogs_manager', 'route' => 'admin.settings.blog', 'route_slug' => NULL, 'label' => 'Blogs Manager', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 103, 'parent_key' => 90, 'order' => 103, 'key' => 'faq_manager', 'route' => 'admin.settings.faq', 'route_slug' => NULL, 'label' => 'FAQs Manager', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 104, 'parent_key' => 90, 'order' => 104, 'key' => 'google_adsense', 'route' => 'admin.settings.adsense', 'route_slug' => NULL, 'label' => 'Google Adsense', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 105, 'parent_key' => NULL, 'order' => 105, 'key' => 'general_settings', 'route' => NULL, 'route_slug' => NULL, 'label' => 'General Settings', 'icon' => 'fa fa-sliders', 'type' => 'group', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 106, 'parent_key' => 105, 'order' => 106, 'key' => 'global_settings', 'route' => 'admin.settings.global', 'route_slug' => NULL, 'label' => 'Global Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 107, 'parent_key' => 105, 'order' => 107, 'key' => 'auth_settings', 'route' => 'admin.settings.oauth', 'route_slug' => NULL, 'label' => 'Auth Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 108, 'parent_key' => 105, 'order' => 108, 'key' => 'registration_settings', 'route' => 'admin.settings.registration', 'route_slug' => NULL, 'label' => 'Registration Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 109, 'parent_key' => 105, 'order' => 109, 'key' => 'smtp_settings', 'route' => 'admin.settings.smtp', 'route_slug' => NULL, 'label' => 'SMTP Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 110, 'parent_key' => 105, 'order' => 110, 'key' => 'gdpr_settings', 'route' => 'admin.settings.gdpr', 'route_slug' => NULL, 'label' => 'GDPR Cookies', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 111, 'parent_key' => 105, 'order' => 111, 'key' => 'languages', 'route' => 'elseyyid.translations.home2', 'route_slug' => NULL, 'label' => 'Languages', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 112, 'parent_key' => 105, 'order' => 112, 'key' => 'system_settings', 'route' => 'admin.settings.system', 'route_slug' => NULL, 'label' => 'System Settings', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 113, 'parent_key' => 105, 'order' => 113, 'key' => 'activation', 'route' => 'admin.settings.activation', 'route_slug' => NULL, 'label' => 'Activation', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 114, 'parent_key' => 105, 'order' => 114, 'key' => 'upgrade_software', 'route' => 'admin.settings.upgrade', 'route_slug' => NULL, 'label' => 'Upgrade Software', 'icon' => 'fa-solid fa-angles-right', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 115, 'parent_key' => NULL, 'order' => 115, 'key' => 'menu_builder', 'route' => 'admin.davinci.configs.menu', 'route_slug' => NULL, 'label' => 'Menu Builder', 'icon' => 'fa-solid fa-bars', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 1, 'extension' => 0, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
            ['id' => 116, 'parent_key' => NULL, 'order' => 116, 'key' => 'ai_speech_to_text_pro', 'route' => 'user.extension.speech.pro', 'route_slug' => NULL, 'label' => 'Speech to Text Pro', 'icon' => 'fa-solid fa-microphone', 'type' => 'item', 'svg' => NULL, 'is_active' => 1, 'is_admin' => 0, 'extension' => 1, 'url' => NULL, 'permission' => NULL, 'conditions' => [], 'badge_text' => NULL, 'badge_type' => NULL, 'children' => [], 'original' => 1],
        ];  

        foreach ($ads as $ad) {
            MenuItem::updateOrCreate(['id' => $ad['id']], $ad);
        }
    }
}
